
#|___________________________________________________________________ 
 | 
 | ViSta - The Visual Statistics System
 | Copyright (c) 1991-2000 by Forrest W. Young
 | For further information contact the author 
 | forrest@unc.edu or http://forrest.psych.unc.edu
 |
 | This file determines MS-Windows 95/98/NT installation configuration 
 | for directories, window layout, fonts and startup privileges
 | and then initiates loading of program files
 |
 | Installation consists of two parts:
 | 1: setup prepares paths and sets pro-version
 | 2: installation configures user environment
 | the first step is also used in make-vista, without second step
 |
 | Six different initializations are possible, tho not all work right:
 | (save-current-workspace) ;ok
 | (save-default-workspace) ;ok
 | (save-custom-workspace)  ;ng
 | (run-current-vista)      ;??
 | (run-default-vista)      ;??
 | (run-custom-vista)       ;??
 |
 | note that *xlispverbose* is not set to t by the -verbose flag at
 | this point in time. it is set at the end of loading all files  
 |___________________________________________________________________ 
 |#



(defun install-vista ()
"Args: none 
Installs vista in local environment, taking these steps:
0 open install.log and print header 
1 setup installation
2 do installation hyperlog"
  (setf *local-install-number* (1+ *local-install-number* ))
  (update-installation-info)
  (format t "~%ViSta Installation Log - Localizing ViSta~2%") 
  (setup-install-vista)
  (do-vista-installation-hyperlog))

(defun setup-install-vista (&optional dont-update-verbose-mode)
"Args: none
Sets up the installation, taking these steps
1 construct paths for initial installation on local machine using ini file
2 check that *initial-install* is t (set in make-distribution)
3 set *pro-version* to t if this is *devel-version*
4 never change *devel-version* except by reading from devel files
5 optionally, display vista flying logo"  

  (when *verbose* (format t "; setup installation of vista~%"))
  (setf *ini-file* (strcat (get-working-directory) "\\wxls32.ini"))
  (setf *installation-startup-path* (strcat (get-working-directory) *separator*))
  (setf *default-path*  *installation-startup-path*)
  (setf *startup-path*  *default-path*)
  (make-default-ini *installation-startup-path*)
  (let* ((ini-paths     (get-ini-paths)))
    (setf *xlib-path*   (first ini-paths))
    (setf *lib-path*    (second ini-paths))
    (setf *user-path*   (third ini-paths))
    (setf *prefs-path*  (fourth ini-paths))
    (setf *system-path* (fifth ini-paths)))   
  (define-vista-paths)
  (read-devel-files)
  (if *devel-version*
      (setf *pro-version* t)
      (setf *pro-version* nil))
  (setf *show-install-loto* t)
  (when *show-install-logo* (display-logo) (pause 60))
  (when *pro-version*
        (when *verbose* (format t "; this is a professional version~%"))
        (unless dont-update-verbose-mode (load "prefs\\verbose.lsp"))
        (setf *show-flying-logo* nil)
        (setf *show-zooming-desktop* nil)
        (setf *show-flying-exit-logo* nil)
        (when *show-install-logo* 
              (send *logo* :set-no-animation)))
  )


  #| 
   | create vista installation hyperlog
   |# 

(defun do-vista-installation-hyperlog ()
  (when *show-install-logo* 
        (setf *logo-location* (send *logo* :location))
        (send *logo* :location 3000 3000))
  (vista-installation-hyperlog))


  #| 
   | after hyperlog installation, save installation workspace
   |#
 
(defun default-install-vista ()
  (setup-install-vista)
  (set-vista-pro-version)
  (set-default-install)
  (update-installation-info)
  (define-vista-paths)
  ;(set-filetypes);fwy aded may 27 2002
  (localize-lispboss);fwy changed to this june 22 2002
  (start-vista))

(defun id-number () (setf *id-number* (update-installation-info)))

(defun update-installation-info (&optional copyright  version)
  (when *verbose* (format t "; updating installation information~%"))
  (setf *invoked-date* (apply #'format nil "~a ~a ~a" (select (date-time) '(2 0 1))))
  (make-vista-id-number)
  (setf *local-vista-id-number* (reverse (format nil "~a.~a" *local-install-number* (first (last (date-time))))))
  (make-vista-copyright) ;sets current year
  (when copyright (vista-copyright nil 3 t))
  (setf *install-date* (time-stamp))
  (setf *install-id* (user-id))
  (setf *registration-number* *install-id*)
  (if (not *compile-date*) (setf *compile-date* *build-date*))
  (make-version)
  (make-vista-id-ini)
  (when version (version)))


(defun make-vista-id-ini ()
  (when *system-path*
        (when *verbose* (format nil "; generating id info"))
        (let ((*id-file* (strcat *default-path* "wxls32.ini")))
          (msw-write-profile-string "User-ID" "ViSta-ID" 
                                    *vista-id* *id-file*)
          (msw-write-profile-string "User-ID" "Local-ID" 
                                    *local-vista-id-number* *id-file*)
          (msw-write-profile-string "User-ID" 
                                    "Registration" *registration-number* *id-file*)
          (msw-write-profile-string "User-ID" 
                                    "Compiled" *compile-date* *id-file*)
          (msw-write-profile-string "User-ID" 
                                    "Built" *build-date* *id-file*)
          (msw-write-profile-string "User-ID" 
                                    "Distributed" *distribution-date* *id-file*)
          (msw-write-profile-string "User-ID" 
                                    "Installed" *install-date* *id-file*)
          (msw-write-profile-string "User-ID" 
                                    "Distributed" *distribution-date* *id-file*)
          )))

(defun start-vista (&optional *show-install-logo*)
  (setf *border-style* 0)
  (setf *desktop-datasheet* nil)
  (setf *vv* nil)
  (setf *version6* t)
  (setf *initial-datasheet* t)
  (setf *free-datasheets* nil)
  (setf *free-text-windows* t)
  (setf *ni* t)
  
  (setf *visible-startup* nil)
  (when *show-install-logo* 
        (apply #'send *logo* :location *logo-location*)
        (fade-splash-screen *logo*))
  (setf *run-number* -10)
  (setf *initial-install* nil)
  (when *pro-version*
        (setf *show-flying-logo* nil)
        (setf *show-zooming-desktop* nil)
        (setf *show-flying-exit-logo* nil))
  (write-prefload-file) ; was (save-all-prefs)
  (verbose nil)
  )


(setf *net-install* (and (boundp '*sssst-4st*) *sssst-4st*))

(defun workspace-type (&optional pref-path)
  (when pref-path (setf *prefs-dir-name* pref-path)
        (setf *prefs-path* (strcat *prefs-dir-name* "\\")))
  (button-hyper-dialog 
   (remove 'nil
           (list "DEFAULT INSTALL " 
                 " CUSTOM INSTALL "  
                 "KEEP OLD INSTALL"
                 (when *net-install* "   NET INSTALL  ")))
   :header "ViSta's new workspace is ready. Choose type of installation:"
   :button-text (remove 'nil (list 
"Default Options are used to install the new make of 
ViSta on this machine"
"You will see the user's hyperlog boxes so you can 
custom install the new make of ViSta on this machine."
"The new make of ViSta is not installed."
(when *net-install* "The new make of ViSta is saved in a form suitable 
for downloading from the net.")))
   :title  "ViSta - The Visual Statistics System" 
   :links (remove 'nil
                  (list '(progn
                          (setf *vista-start-case* 9)
                          (default-install-vista))
                        '(progn
                          (setf *vista-start-case* 9)
                          (write-prefload-file *make-distribution*)
                          (install-vista-hyperlog))
                        '(progn
                          (setf *vista-start-case* 0)
                          (write-prefload-file *make-distribution*)
                          (cond
                            ((probe-file "xlisp.bak")
                             (rename-file "xlisp.bak" "xlisp.wks")
                             (format t "; renamed xlisp.bak -> xlisp.wks ~%")
                             (message-dialog "OLD INSTALL KEPT"))
                            (t
                             (message-dialog 
                              (format t "; statinit: no xlisp.bak or xlisp.wks file. sol"))))
                          (exit))
                        '(when *net-install*
                               (progn
                                (setf *vista-start-case* 1)
                                (write-prefload-file *make-distribution*)
                                (message-dialog "UNLOCALIZED NET INSTALL MADE")
                                (save-workspace "xlisp.wks")))
                        ))
   
   :action   (if *net-install* 
                 (list '(continue) '(continue) '(continue) '(continue))
                 (list '(continue) '(continue) '(continue)))
   :help    '(send *vista-hyperlog* :get-ini-loc-help)
   :layout   (list (list 'help))
   :divider  (format nil "____________________________________________________________")
   :footer   "Click HELP for help using this dialog"
   ))